/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSaveFileDialog.h,v 1.3 1999/09/30 05:00:15 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSaveFileDialog_h	// [
#define Included_CSaveFileDialog_h

#include "pgpClassesConfig.h"
#include <commdlg.h>

_PGP_BEGIN

// Types

class CPath;


// Class CSaveFileDialog

class CSaveFileDialog
{
	NOT_COPYABLE(CSaveFileDialog)

public:
	typedef PGPBoolean (*ValidatePathFunc)(const CPath& path, 
		void *userVal);

public:
	CSaveFileDialog() { }
	~CSaveFileDialog() { }

	void	Choose(HWND parentWnd, CPath& path, 
		const char *defaultPath = NULL, const char *title = NULL, 
		const char *filter = NULL, const char *defaultExt = NULL, 
		ValidatePathFunc pfnValidatePath = NULL, void *userVal = NULL);

private:
	OPENFILENAME		mOfn;
	ValidatePathFunc	mPfnValidatePath;
	void				*mUserVal;

	UINT	SaveDialogHookProcAux(HWND hdlg, LPOFNOTIFY pON);

	static UINT CALLBACK	SaveDialogHookProc(HWND hdlg, UINT uiMsg, 
		WPARAM wParam, LPARAM lParam);
};

_PGP_END

#endif	// ] Included_CSaveFileDialog_h
